
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Jamie's Diet")

# Create variables
chicken = m.addVar(lb=0, name="chicken") # units of chicken
beef = m.addVar(lb=0, name="beef") # units of beef

# Set objective function
m.setObjective(3.4 * chicken + 7.5 * beef, GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * chicken + 30 * beef >= 100, "Protein Requirement")
m.addConstr(6 * chicken + 40 * beef >= 60, "Fat Requirement")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Units of Chicken: {chicken.x:.2f}")
    print(f"Units of Beef: {beef.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

