
from gurobipy import *

# Create a new model
m = Model("Jamie_Diet")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="beef", lb=0)

# Set the objective function
m.setObjective(3.4*x1 + 7.5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 30*x2 >= 100, "protein_constraint")
m.addConstr(6*x1 + 40*x2 >= 60, "fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount of chicken: {x1.x}")
    print(f"Amount of beef: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
