
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="chicken", lb=0)
    x2 = model.addVar(name="beef", lb=0)

    # Objective function: minimize cost
    model.setObjective(3.4 * x1 + 7.5 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * x1 + 30 * x2 >= 100, name="protein_requirement")
    model.addConstr(6 * x1 + 40 * x2 >= 60, name="fat_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal cost: ", model.objVal)
        print("Units of chicken: ", x1.varValue)
        print("Units of beef: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_diet_problem()
