
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("webcam_optimization")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="standard_def")  # Standard definition webcams
x2 = m.addVar(vtype=GRB.INTEGER, name="high_def")  # High definition webcams


# Set objective function
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*x1 + 250*x2 <= 40000, "budget_constraint")
m.addConstr(x1 + x2 <= 275, "demand_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of standard definition webcams: {x1.x}")
    print(f"Number of high definition webcams: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

