
from gurobipy import *

# Create a new model
m = Model("WebCam_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="standard_definition_webcams")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="high_definition_webcams")

# Set the objective function
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*x1 + 250*x2 <= 40000, "investment_constraint")
m.addConstr(x1 + x2 <= 275, "demand_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of standard definition web-cams: {x1.x}")
    print(f"Number of high definition web-cams: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
