
import gurobipy as gp

# Create a new model
model = gp.Model("WebCam_Optimization")

# Define variables
x1 = model.addVar(name="standard_definition_webcams", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="high_definition_webcams", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(100*x1 + 125*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(150*x1 + 250*x2 <= 40000, name="inventory_cost_constraint")
model.addConstr(x1 + x2 <= 275, name="demand_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Standard Definition Webcams: {x1.varValue}")
    print(f"High Definition Webcams: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
