
import gurobipy as gp

# Create a new model
m = gp.Model("Hostel_Room_Optimization")

# Create variables
heated_rooms = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="heated_rooms")
unheated_rooms = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="unheated_rooms")


# Set objective function
m.setObjective(50 * heated_rooms + 35 * unheated_rooms, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(heated_rooms + unheated_rooms <= 40, "Total rooms")
m.addConstr(heated_rooms >= 15, "Minimum heated rooms")
m.addConstr(unheated_rooms >= 4 * heated_rooms, "Unheated preference")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of heated rooms: {heated_rooms.x}")
    print(f"Number of unheated rooms: {unheated_rooms.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

