
from gurobipy import *

# Create a new model
m = Model("hostel_rooms")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="heated_rooms")
x2 = m.addVar(vtype=GRB.INTEGER, name="unheated_rooms")

# Set objective function
m.setObjective(50*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 40, "total_rooms")
m.addConstr(x1 >= 15, "min_heated_rooms")
m.addConstr(x2 >= 4*x1, "unheated_vs_heated")
m.addConstr(x1 >= 0, "non_negative_heated")
m.addConstr(x2 >= 0, "non_negative_unheated")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Heated rooms: {x1.x}")
    print(f"Unheated rooms: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
