
import gurobi

def solve_hostel_problem():
    model = gurobi.Model()

    x1 = model.addVar(name="heated_rooms", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="unheated_rooms", lb=0, vtype=gurobi.GRB.INTEGER)

    model.setObjective(50 * x1 + 35 * x2, gurobi.GRB.MAXIMIZE)

    model.addConstr(x1 + x2 <= 40, name="total_rooms")
    model.addConstr(x1 >= 15, name="min_heated")
    model.addConstr(x2 >= 4 * x1, name="unheated_preference")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Heated rooms = {x1.varValue}, Unheated rooms = {x2.varValue}")
        print(f"Max Profit: ${50*x1.varValue + 35*x2.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible")
    else:
        print("No optimal solution found")

solve_hostel_problem()
