
from gurobipy import *

# Create a new model
model = Model("Engineering_Company_Optimization")

# Define the variables
x1 = model.addVar(vtype=GRB.INTEGER, name="new_grad_engineers")
x2 = model.addVar(vtype=GRB.INTEGER, name="senior_engineers")

# Set the objective function
model.setObjective(1000*x1 + 3000*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(1000*x1 + 3000*x2 <= 100000, "wage_bill_constraint")
model.addConstr(x1 + x2 >= 50, "total_engineers_constraint")
model.addConstr(x2 >= 10, "senior_engineers_minimum_constraint")
model.addConstr(x2 >= (1/3)*x1, "senior_to_new_grad_ratio_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of new grad engineers: {x1.x}")
    print(f"Number of senior engineers: {x2.x}")
    print(f"Total wage bill: ${1000*x1.x + 3000*x2.x}")
else:
    print("No optimal solution found")
