
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="new_grad_engineers")
    x2 = model.addVar(lb=0, name="senior_engineers")

    # Objective function: minimize the wage bill
    model.setObjective(1000*x1 + 3000*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1000*x1 + 3000*x2 <= 100000, name="wage_bill_constraint")
    model.addConstr(x1 + x2 >= 50, name="total_engineers_constraint")
    model.addConstr(x2 >= 10, name="senior_engineers_min_constraint")
    model.addConstr(x2 >= (1/3)*x1, name="senior_to_new_grad_ratio_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Number of new grad engineers: {x1.varValue}")
        print(f"Number of senior engineers: {x2.varValue}")
        print(f"Minimum wage bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
