
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("essential_oil_production")

# Create variables
ylang_ylang = m.addVar(name="ylang_ylang")  # Acres of ylang ylang
vanilla = m.addVar(name="vanilla")  # Acres of vanilla


# Set objective function
m.setObjective(150 * ylang_ylang + 100 * vanilla, GRB.MAXIMIZE)

# Add constraints
m.addConstr(ylang_ylang + vanilla <= 100, "Total_acres")
m.addConstr(ylang_ylang >= 10, "Min_ylang_ylang")
m.addConstr(vanilla >= 20, "Min_vanilla")
m.addConstr(ylang_ylang <= 2 * vanilla, "Ylang_vanilla_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Acres of ylang ylang: {ylang_ylang.x}")
    print(f"Acres of vanilla: {vanilla.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

