
from gurobipy import *

# Create a new model
m = Model("Essential_Oil_Production")

# Define variables
x1 = m.addVar(lb=0, name="Ylang_Ylang_Acres")
x2 = m.addVar(lb=0, name="Vanilla_Acres")

# Set the objective function to maximize profit
m.setObjective(150*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 10, "Minimum_Ylang_Ylang")
m.addConstr(x2 >= 20, "Minimum_Vanilla")
m.addConstr(x1 + x2 <= 100, "Total_Land")
m.addConstr(x1 <= 2*x2, "Ylang_Ylang_to_Vanilla_Ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Grow {x1.x} acres of ylang ylang and {x2.x} acres of vanilla.")
else:
    print("No optimal solution found.")
