
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=10, name="x1")  # acres of ylang ylang
    x2 = model.addVar(lb=20, name="x2")  # acres of vanilla

    # Objective function
    model.setObjective(150 * x1 + 100 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_acres")
    model.addConstr(x1 <= 2 * x2, name="ratio_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of ylang ylang: {x1.varValue}")
        print(f"Optimal acres of vanilla: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
