
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
potatoes = m.addVar(name="potatoes")
squash = m.addVar(name="squash")

# Set objective function
m.setObjective(700 * potatoes + 144 * squash, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(potatoes + squash <= 1000, "land_constraint")
m.addConstr(20 * potatoes + 23 * squash <= 1200, "tractor_constraint")
m.addConstr(10 * potatoes + 110 * squash <= 26400, "capital_constraint")
m.addConstr(potatoes >= 0, "potatoes_nonnegative")
m.addConstr(squash >= 0, "squash_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Plant {potatoes.x} acres of potatoes')
    print(f'Plant {squash.x} acres of squash')
    print(f'Maximum profit: ${m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}')

