
from gurobipy import *

# Create a new model
m = Model("Farming_Optimization")

# Define the variables
x1 = m.addVar(name='acres_of_potatoes', lb=0)
x2 = m.addVar(name='acres_of_squash', lb=0)

# Set the objective function: Maximize profit
m.setObjective(700*x1 + 144*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1000, name='land_availability')
m.addConstr(20*x1 + 23*x2 <= 1200, name='tractor_time')
m.addConstr(10*x1 + 110*x2 <= 26400, name='capital_availability')

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of Potatoes: {x1.x}")
    print(f"Acres of Squash: {x2.x}")
    print(f"Total Profit: ${700*x1.x + 144*x2.x:.2f}")
else:
    print("No optimal solution found")
