
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="potatoes")
    x2 = model.addVar(lb=0, name="squash")

    # Objective function
    model.setObjective(700*x1 + 144*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 1000, name="land_constraint")
    model.addConstr(20*x1 + 23*x2 <= 1200, name="tractor_time_constraint")
    model.addConstr(10*x1 + 110*x2 <= 26400, name="capital_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of potatoes: {x1.varValue}")
        print(f"Acres of squash: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
