
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Amy's Bakery")

# Create variables
croissant = m.addVar(vtype=GRB.CONTINUOUS, name="croissant")
ficelle = m.addVar(vtype=GRB.CONTINUOUS, name="ficelle")

# Set objective function
m.setObjective(4.5 * croissant + 3.5 * ficelle, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * croissant + 17 * ficelle <= 350, "mixing_time")
m.addConstr(2 * croissant + 1 * ficelle <= 45, "vanilla_extract")
m.addConstr(croissant >= 0, "non_negativity_croissant")  # Ensure non-negative quantities
m.addConstr(ficelle >= 0, "non_negativity_ficelle")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Number of Croissants: {croissant.x:.2f}")
    print(f"Number of Ficelles: {ficelle.x:.2f}")

