
from gurobipy import *

# Create a new model
model = Model("Bakery_Optimization")

# Create variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="croissants")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="ficelles")

# Set the objective function
model.setObjective(4.5*x1 + 3.5*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*x1 + 17*x2 <= 350, "mixing_time")
model.addConstr(2*x1 + x2 <= 45, "vanilla_extract")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of croissants: {x1.x}")
    print(f"Number of ficelles: {x2.x}")
    print(f"Maximum revenue: ${4.5*x1.x + 3.5*x2.x:.2f}")
else:
    print("No optimal solution found.")
