
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="croissant", lb=0)
x2 = m.addVar(name="ficelle", lb=0)

# Define the objective function
m.setObjective(4.5 * x1 + 3.5 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(12 * x1 + 17 * x2 <= 350, name="mixing_time")
m.addConstr(2 * x1 + x2 <= 45, name="vanilla_extract")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Croissants: {x1.varValue}")
    print(f"Ficelles: {x2.varValue}")
    print(f"Revenue: {4.5 * x1.varValue + 3.5 * x2.varValue}")
else:
    print("No optimal solution found.")
