
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
carrots = m.addVar(name="carrots")
beets = m.addVar(name="beets")

# Set objective function
m.setObjective(500 * carrots + 400 * beets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(carrots + beets <= 30, "total_acres")
m.addConstr(carrots >= 3, "min_carrots")
m.addConstr(beets >= 5, "min_beets")
m.addConstr(beets <= 2 * carrots, "beet_carrot_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Plant {carrots.x} acres of carrots')
    print(f'Plant {beets.x} acres of beets')
    print(f'Maximum profit: ${m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}')

