
from gurobipy import *

# Create a new model
m = Model("Farm_Optimization")

# Define variables
x1 = m.addVar(name="carrots", vtype=GRB.CONTINUOUS, lb=3)  # Acres of carrots, minimum 3 acres
x2 = m.addVar(name="beets", vtype=GRB.CONTINUOUS, lb=5)    # Acres of beets, minimum 5 acres

# Set the objective function: Maximize profit
m.setObjective(500*x1 + 400*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 30, name="total_acres")     # Total acres constraint
m.addConstr(x2 <= 2*x1, name="beets_to_carrots")   # Beets to carrots ratio constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Acres of carrots: {x1.x}")
    print(f"Acres of beets: {x2.x}")
    print(f"Maximum profit: ${500*x1.x + 400*x2.x:.2f}")
else:
    print("No optimal solution found.")
