
import gurobipy as gp

# Create a new model
model = gp.Model("Farmer_Acres_Optimization")

# Define the variables
x1 = model.addVar(name="carrots", lb=3)  # Acres of carrots, minimum 3 acres
x2 = model.addVar(name="beets", lb=5)   # Acres of beets, minimum 5 acres

# Objective function: Maximize 500*x1 + 400*x2
model.setObjective(500*x1 + 400*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 30, name="total_acres")  # Total acres constraint
model.addConstr(x2 <= 2*x1, name="beets_to_carrots_ratio")  # Beets to carrots ratio constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of carrots: {x1.varValue}")
    print(f"Optimal acres of beets: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible")
