
import gurobipy as gp

# Create a new model
m = gp.Model("bean_bag_toss")

# Create variables
red_bags = m.addVar(vtype=gp.GRB.INTEGER, name="red_bags")
blue_bags = m.addVar(vtype=gp.GRB.INTEGER, name="blue_bags")

# Set objective function
m.setObjective(5 * red_bags + 8 * blue_bags, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(red_bags >= 3, "min_red")
m.addConstr(blue_bags >= 2, "min_blue")
m.addConstr(red_bags <= 8, "max_red")
m.addConstr(blue_bags <= 8, "max_blue")
m.addConstr(red_bags + blue_bags == 12, "total_bags")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Red bags = {red_bags.x}, Blue bags = {blue_bags.x}")
    print(f"Total points: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

