
from gurobipy import *

# Create a new model
m = Model("Bean_Bag_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="red_bean_bags")
x2 = m.addVar(vtype=GRB.INTEGER, name="blue_bean_bags")

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 3, "at_least_3_red")
m.addConstr(x2 >= 2, "at_least_2_blue")
m.addConstr(x1 <= 8, "at_most_8_red")
m.addConstr(x2 <= 8, "at_most_8_blue")
m.addConstr(x1 + x2 == 12, "total_bean_bags")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red bean bags: {x1.x}")
    print(f"Blue bean bags: {x2.x}")
    print(f"Total points: {5*x1.x + 8*x2.x}")
else:
    print("No optimal solution found")
