
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wood_artist")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="display_shelf") # number of display shelves
x2 = m.addVar(vtype=GRB.INTEGER, name="plant_stand") # number of plant stands


# Set objective function
m.setObjective(55*x1 + 45*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 20*x2 <= 350, "carving_constraint")
m.addConstr(20*x1 + 10*x2 <= 600, "polishing_constraint")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Display shelves: {x1.x}")
    print(f"  Plant stands: {x2.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

