
from gurobipy import *

# Create a new model
m = Model("Wood_Artist_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="display_shelves", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="plant_stands", lb=0)

# Set the objective function
m.setObjective(55*x1 + 45*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 20*x2 <= 350, "carving_time")
m.addConstr(20*x1 + 10*x2 <= 600, "polishing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
