
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="display_shelf", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="plant_stand", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(55 * x1 + 45 * x2, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(25 * x1 + 20 * x2 <= 350, name="carving_time")
    model.addConstr(20 * x1 + 10 * x2 <= 600, name="polishing_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Display shelves: {x1.varValue}")
        print(f"Plant stands: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
