
import gurobipy as gp

# Create a new model
model = gp.Model("BagelOptimization")

# Create variables
eastside_hours = model.addVar(lb=0, name="Eastside_Bakery_Hours")
westside_hours = model.addVar(lb=0, name="Westside_Bakery_Hours")


# Set objective function
model.setObjective(300 * eastside_hours + 500 * westside_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(100 * eastside_hours + 50 * westside_hours >= 800, "Everything_Bagels")
model.addConstr(80 * eastside_hours + 60 * westside_hours >= 600, "Blueberry_Bagels")
model.addConstr(30 * eastside_hours + 100 * westside_hours >= 1000, "Regular_Bagels")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Eastside Bakery Hours: {eastside_hours.x}")
    print(f"Westside Bakery Hours: {westside_hours.x}")
    print(f"Total Cost: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

