
import gurobipy as gp

# Create a new model
model = gp.Model("Bagel_Production")

# Define variables
x1 = model.addVar(name="Eastside_bakery_hours", lb=0)
x2 = model.addVar(name="Westside_bakery_hours", lb=0)

# Objective function: Minimize cost
model.setObjective(300*x1 + 500*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(100*x1 + 50*x2 >= 800, name="everything_bagels")
model.addConstr(80*x1 + 60*x2 >= 600, name="blueberry_bagels")
model.addConstr(30*x1 + 100*x2 >= 1000, name="regular_bagels")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Eastside bakery hours: {x1.varValue}")
    print(f"Westside bakery hours: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
