
import gurobipy as gp

# Create a new model
model = gp.Model("BlueOceanProduction")

# Create decision variables
gamma_hours = model.addVar(lb=0, name="gamma_hours")  # Hours running plant Gamma
delta_hours = model.addVar(lb=0, name="delta_hours")  # Hours running plant Delta

# Set objective function: Minimize total cost
model.setObjective(35 * gamma_hours + 95 * delta_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * gamma_hours + 6 * delta_hours >= 90, "asphalt_demand")  # Asphalt demand
model.addConstr(3 * gamma_hours + 5 * delta_hours >= 85, "bricks_demand")  # Bricks demand


# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${model.objVal:.2f}")
    print(f"Hours running plant Gamma: {gamma_hours.x:.2f}")
    print(f"Hours running plant Delta: {delta_hours.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {model.status}")

