
from gurobipy import *

# Create a new model
m = Model("BlueOceanProduction")

# Define variables
x1 = m.addVar(lb=0, name="hours_Gamma")
x2 = m.addVar(lb=0, name="hours_Delta")

# Set the objective function
m.setObjective(35*x1 + 95*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 >= 90, "asphalt_production")
m.addConstr(3*x1 + 5*x2 >= 85, "bricks_production")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours plant Gamma should run: {x1.x}")
    print(f"Hours plant Delta should run: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
