
import gurobi

def solve_production_planning():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='Gamma_hours', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='Delta_hours', lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(35 * x1 + 95 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(4 * x1 + 6 * x2 >= 90, name='asphalt_demand')
    model.addConstr(3 * x1 + 5 * x2 >= 85, name='bricks_demand')

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours of running plant Gamma: {x1.x}')
        print(f'Hours of running plant Delta: {x2.x}')
        print(f'Total cost: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_production_planning()
