
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
carrots = m.addVar(name="carrots")
pumpkins = m.addVar(name="pumpkins")

# Set objective function
m.setObjective(80*carrots + 124*pumpkins, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(carrots + pumpkins <= 1500, "land_constraint")
m.addConstr(15*carrots + 20*pumpkins <= 1000, "tractor_constraint")
m.addConstr(12*carrots + 55*pumpkins <= 25000, "capital_constraint")
m.addConstr(carrots >= 0, "carrots_nonnegative")
m.addConstr(pumpkins >= 0, "pumpkins_nonnegative")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {carrots.x:.2f} acres of carrots")
    print(f"Plant {pumpkins.x:.2f} acres of pumpkins")
    print(f"Maximum profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

