
from gurobipy import *

# Create a new model
m = Model("Frank's Farm")

# Add variables
x1 = m.addVar(lb=0, name="acres_of_carrots")
x2 = m.addVar(lb=0, name="acres_of_pumpkins")

# Set the objective function
m.setObjective(80*x1 + 124*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1500, "land_constraint")
m.addConstr(15*x1 + 20*x2 <= 1000, "tractor_time_constraint")
m.addConstr(12*x1 + 55*x2 <= 25000, "capital_constraint")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
