
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="carrots")
    x2 = model.addVar(lb=0, name="pumpkins")

    # Objective function
    model.setObjective(80*x1 + 124*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 1500, name="land_constraint")
    model.addConstr(15*x1 + 20*x2 <= 1000, name="tractor_time_constraint")
    model.addConstr(12*x1 + 55*x2 <= 25000, name="capital_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Acres of carrots: {x1.varValue}")
        print(f"Acres of pumpkins: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
