
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Car_Truck_Inventory")

# Create variables
cars = m.addVar(vtype=GRB.INTEGER, name="cars")
trucks = m.addVar(vtype=GRB.INTEGER, name="trucks")

# Set objective function
m.setObjective(2000 * cars + 4000 * trucks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * cars + 45 * trucks <= 450, "Space_Constraint")  # Space constraint
m.addConstr(cars >= 0.6 * (cars + trucks), "Car_Ratio_Constraint")  # Car ratio constraint
m.addConstr(30000 * cars + 40000 * trucks <= 800000, "Budget_Constraint")  # Budget constraint
m.addConstr(cars >= 0, "Non_Negative_Cars")  # Non-negativity constraint
m.addConstr(trucks >= 0, "Non_Negative_Trucks")  # Non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Cars: {cars.x}")
    print(f"Number of Trucks: {trucks.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

