
from gurobipy import *

# Create a new model
m = Model("Car_Truck_Inventory")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="cars")
x2 = m.addVar(vtype=GRB.INTEGER, name="trucks")

# Set the objective function
m.setObjective(2000*x1 + 4000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 45*x2 <= 450, "space_constraint")
m.addConstr(x1 >= 1.5*x2, "min_cars_constraint")
m.addConstr(30000*x1 + 40000*x2 <= 800000, "capital_constraint")
m.addConstr(x1 >= 0, "non_negativity_cars")
m.addConstr(x2 >= 0, "non_negativity_trucks")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Cars = {x1.x}, Trucks = {x2.x}")
    print(f"Maximum Profit: ${2000*x1.x + 4000*x2.x}")
else:
    print("No optimal solution found")
