
import gurobipy as gp

# Create a new model
model = gp.Model("Car_Truck_Stocking")

# Define variables
x1 = model.addVar(name="cars", lb=0, vtype=gp.GRB.INTEGER)  # Number of cars
x2 = model.addVar(name="trucks", lb=0, vtype=gp.GRB.INTEGER)  # Number of trucks

# Objective function: Maximize profit
model.setObjective(2000*x1 + 4000*x2, gp.GRB.MAXIMIZE)

# Space constraint
model.addConstr(30*x1 + 45*x2 <= 450, name="Space_Constraint")

# Product mix constraint
model.addConstr(x1 >= 1.5*x2, name="Product_Mix_Constraint")

# Capital constraint
model.addConstr(30000*x1 + 40000*x2 <= 800000, name="Capital_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of cars: {x1.varValue}")
    print(f"Optimal number of trucks: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible.")
