
from gurobipy import *

# Create a new model
m = Model("Terracotta_Pots")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="oval_pots", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="square_pots", lb=0)

# Set the objective function
m.setObjective(4.5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x1 + 35*x2 <= 2500, "shaping_time")
m.addConstr(50*x1 + 80*x2 <= 3800, "baking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of oval pots: {x1.x}")
    print(f"Number of square pots: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
