
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="oval_pots", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(name="square_pots", lb=0, vtype=gp.GRB.CONTINUOUS)

# Set the objective function
m.setObjective(4.5 * x1 + 8 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(40 * x1 + 35 * x2 <= 2500, name="shaping_time")
m.addConstr(50 * x1 + 80 * x2 <= 3800, name="baking_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of oval pots: {x1.varValue}")
    print(f"Number of square pots: {x2.varValue}")
    print(f"Maximal profit: {m.objVal}")
else:
    print("No optimal solution found.")
