
import gurobipy as gp

# Create a new model
model = gp.Model("AlmondMix")

# Create decision variables
x1 = model.addVar(lb=0, name="FirstMix")  # kg of first mix
x2 = model.addVar(lb=0, name="SecondMix") # kg of second mix

# Set objective function
model.setObjective(12*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.3*x1 + 0.4*x2 <= 100, "HoneyRoasted")
model.addConstr(0.7*x1 + 0.6*x2 <= 150, "ChocolateCovered")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"First mix (kg): {x1.x}")
    print(f"Second mix (kg): {x2.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

