
from gurobipy import *

# Create a model
m = Model("Honey_and_Chocolate_Almonds")

# Define the variables
x1 = m.addVar(name="x1", lb=0)
x2 = m.addVar(name="x2", lb=0)

# Set the objective function
m.setObjective(12*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.3*x1 + 0.4*x2 <= 100, name="honey_roasted_almonds")
m.addConstr(0.7*x1 + 0.6*x2 <= 150, name="chocolate_covered_almonds")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"x1 = {x1.x}")
    print(f"x2 = {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
