
import gurobi

def solve_almond_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='first_mix', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='second_mix', lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize 12*x1 + 15*x2
    model.setObjective(12*x1 + 15*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(0.30*x1 + 0.40*x2 <= 100, name='honey_roasted_almonds')
    model.addConstr(0.70*x1 + 0.60*x2 <= 150, name='chocolate_covered_almonds')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_almond_mix_problem()
