
import gurobipy as gp

# Create a new model
model = gp.Model("Physics_Contest")

# Create variables
multiple_choice = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="multiple_choice")
short_answer = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="short_answer")


# Set objective function
model.setObjective(2 * multiple_choice + 5 * short_answer, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(multiple_choice + short_answer <= 30, "Total_questions")
model.addConstr(multiple_choice >= 15, "Min_multiple_choice")
model.addConstr(short_answer >= 10, "Min_short_answer")
model.addConstr(multiple_choice <= 20, "Max_multiple_choice")
model.addConstr(short_answer <= 20, "Max_short_answer")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {model.objVal}")
    print(f"Number of multiple choice questions: {multiple_choice.x}")
    print(f"Number of short answer questions: {short_answer.x}")
else:
    print("Infeasible or unbounded")

