
from gurobipy import *

# Create a new model
m = Model("Nolan's Contest")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="multiple_choice_questions")
x2 = m.addVar(vtype=GRB.INTEGER, name="short_answer_questions")

# Set objective function
m.setObjective(2*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 20, "max_multiple_choice")
m.addConstr(x2 <= 20, "max_short_answer")
m.addConstr(x1 >= 15, "min_multiple_choice")
m.addConstr(x2 >= 10, "min_short_answer")
m.addConstr(x1 + x2 <= 30, "total_questions")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Multiple Choice Questions: {x1.x}")
    print(f"Short Answer Questions: {x2.x}")
    print(f"Total Score: {m.ObjVal}")
else:
    print("No optimal solution found")
