
import gurobi

def nolan_physics_contest():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=20, name="multiple_choice")
    x2 = model.addVar(lb=0, ub=20, name="short_answer")

    # Set objective function
    model.setObjective(2*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 30, name="total_questions")
    model.addConstr(x1 >= 15, name="min_multiple_choice")
    model.addConstr(x2 >= 10, name="min_short_answer")
    model.addConstr(x1 <= 20, name="max_multiple_choice")
    model.addConstr(x2 <= 20, name="max_short_answer")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Multiple choice questions: {x1.varValue}")
        print(f"Short answer questions: {x2.varValue}")
        print(f"Max score: {2*x1.varValue + 5*x2.varValue}")
    else:
        print("No optimal solution found.")

nolan_physics_contest()
