
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("car_bus_wash")

# Create variables
cars = m.addVar(vtype=GRB.INTEGER, name="cars")
buses = m.addVar(vtype=GRB.INTEGER, name="buses")

# Set objective function
m.setObjective(50 * cars + 75 * buses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * cars + 50 * buses <= 5000, "watering_time")
m.addConstr(10 * cars + 20 * buses <= 1500, "soap_cost")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of cars to wash: {cars.x}")
    print(f"  Number of buses to wash: {buses.x}")
    print(f"  Maximum earnings: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

