
from gurobipy import *

# Create a new model
m = Model("Car_Bus_Washing")

# Add variables to the model
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="cars")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="buses")

# Set the objective function
m.setObjective(50*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(30*x1 + 50*x2 <= 5000, "watering_time")
m.addConstr(10*x1 + 20*x2 <= 1500, "soap_cost")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum earnings: {m.objVal}")
else:
    print("No optimal solution found")
