
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cars", lb=0, ub=None)  # Number of cars
    x2 = model.addVar(name="buses", lb=0, ub=None)  # Number of buses

    # Objective function: Maximize earnings
    model.setObjective(50*x1 + 75*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30*x1 + 50*x2 <= 5000, name="watering_time")  # Watering time constraint
    model.addConstr(10*x1 + 20*x2 <= 1500, name="soap_cost")  # Soap cost constraint

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: cars = {x1.varValue}, buses = {x2.varValue}")
        print(f"Maximum earnings: ${50*x1.varValue + 75*x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
